package org.gcube.informationsystem.types.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.gcube.com.fasterxml.jackson.annotation.JsonProperty;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.relations.IsRelatedTo;

/**
 * Defines a relationship between resources within a {@link ResourceSchema}.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface RelatedResourcesEntry {

	/**
	 * The source resource of the relationship.
	 *
	 * @return The source resource class.
	 */
	@JsonProperty
	Class<? extends Resource> source() default Resource.class;

	/**
	 * The relation type connecting the resources.
	 *
	 * @return The relation class.
	 */
	@SuppressWarnings("rawtypes")
	@JsonProperty
	Class<? extends IsRelatedTo> relation() default IsRelatedTo.class;

	/**
	 * The target resource of the relationship.
	 *
	 * @return The target resource class.
	 */
	@JsonProperty
	Class<? extends Resource> target() default Resource.class;

	/**
	 * A description of the relationship.
	 *
	 * @return The description.
	 */
	@JsonProperty
	String description() default "";

}