package org.gcube.informationsystem.types.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.gcube.informationsystem.model.reference.entities.Entity;
import org.gcube.informationsystem.types.TypeMapper;
import org.gcube.informationsystem.types.reference.properties.PropertyDefinition;

/**
 * It is used by {@link TypeMapper} to identify which getter method are
 * related to and {@link Entity} {@link PropertyDefinition}.
 * The name of the property is obtained by removing "get" or "is" from method 
 * name and lower casing the first letter.
 * 
 * @author Luca Frosini (ISTI - CNR)
 */
@Documented
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface ISProperty {

	/**
	 * The name of the property.
	 *
	 * @return The name.
	 */
	String name() default "";
	/**
	 * The type of the property.
	 *
	 * @return The type.
	 */
	Class<?> type() default GetReturnType.class;
	/**
	 * A description of the property.
	 *
	 * @return The description.
	 */
	String description() default "";
	/**
	 * Whether the property is mandatory.
	 *
	 * @return {@code true} if mandatory.
	 */
	boolean mandatory() default false;
	/**
	 * Whether the property is read-only.
	 *
	 * @return {@code true} if read-only.
	 */
	boolean readonly() default false;
	/**
	 * Whether the property can be null.
	 *
	 * @return {@code true} if nullable.
	 */
	boolean nullable() default true;
	/**
	 * The minimum value for a numeric property.
	 *
	 * @return The minimum value.
	 */
	int min() default -1;
	/**
	 * The maximum value for a numeric property.
	 *
	 * @return The maximum value.
	 */
	int max() default -1;
	/**
	 * A regular expression for validating a string property.
	 *
	 * @return The regular expression.
	 */
	String regexpr() default "";
	/**
	 * The default value of the property, as a string.
	 *
	 * @return The default value.
	 */
	String defaultValue() default "null";
	
}
