package org.gcube.informationsystem.types.annotations;

import org.gcube.informationsystem.types.PropertyTypeName.BaseType;

/**
 * A marker interface used as the default value for the {@code type} attribute
 * in the {@link ISProperty} annotation.
 * <p>
 * This indicates that the property's type should be inferred from the return
 * type of the annotated method. It serves as a placeholder because annotation
 * attributes cannot have {@code null} as a default, and using {@code Object.class}
 * would be ambiguous as it maps to {@link BaseType#ANY}.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
public interface GetReturnType {

}
