package org.gcube.informationsystem.types.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.gcube.informationsystem.base.reference.Element;

/**
 * Indicates that an {@link Element} type is final and cannot be extended.
 * <p>
 * This is necessary because type definitions are based on interfaces, so this
 * annotation provides an explicit way to mark a type as non-extendable.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface Final {

}
