package org.gcube.informationsystem.types.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Specifies a custom implementation class to be used for deserialization,
 * serving as an alternative to {@code @JsonDeserialize}.
 * <p>
 * This allows for overriding the default implementation class of an interface.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface Deserialize {
	
	/**
	 * The implementation class to use for deserialization.
	 *
	 * @return The implementation class.
	 */
	public Class<?> as() default Void.class;

}

