package org.gcube.informationsystem.types.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.gcube.informationsystem.model.reference.entities.Entity;
import org.gcube.informationsystem.model.reference.relations.Relation;

/**
 * Indicates that an {@link Entity} or {@link Relation} interface is abstract
 * and cannot be instantiated directly.
 * <p>
 * This annotation is necessary because, while all interfaces are implicitly
 * abstract in Java, this explicitly marks a type as abstract within the
 * Information System model's type definition, which is derived via reflection.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface Abstract {

}
