package org.gcube.informationsystem.tree;

import java.util.Set;

/**
 * An interface for extracting identification and relationship information from
 * elements to be used in a {@link Tree}.
 *
 * @param <T> The type of the element.
 * @author Luca Frosini (ISTI - CNR)
 */
public interface NodeInformation<T> {

	/**
	 * Returns a unique identifier for the given element.
	 *
	 * @param t The element.
	 * @return The unique identifier.
	 */
	public String getIdentifier(T t);
	
	/**
	 * Returns the identifiers of the parents of the given element.
	 *
	 * @param root The root element of the tree.
	 * @param t    The element.
	 * @return A set of parent identifiers.
	 */
	public Set<String> getParentIdentifiers(T root, T t);
	
}
