package org.gcube.informationsystem.tree;

/**
 * An interface for performing an operation on a {@link Node} of a {@link Tree}.
 *
 * @param <T> The type of the element in the node.
 * @author Luca Frosini (ISTI - CNR)
 */
public interface NodeElaborator<T> {

	/**
	 * Performs an operation on the given node.
	 *
	 * @param node  The node to process.
	 * @param level The depth of the node in the tree.
	 * @throws Exception if an error occurs during elaboration.
	 */
	public void elaborate(Node<T> node, int level) throws Exception;

}
