/**
 * 
 */
package org.gcube.informationsystem.serialization;

import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.discovery.DiscoveredElementAction;

/**
 * A {@link DiscoveredElementAction} that registers discovered element types
 * with the {@link ElementMapper}.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
public class ElementMappingAction implements DiscoveredElementAction<Element> {

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void analizeElement(Class<Element> e) throws Exception {
		ElementMapper.registerSubtype(e);
	}

}
