package org.gcube.informationsystem.serialization;

import java.io.IOException;
import java.util.Map;

import org.gcube.com.fasterxml.jackson.core.JsonGenerator;
import org.gcube.com.fasterxml.jackson.databind.SerializerProvider;
import org.gcube.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.gcube.informationsystem.model.reference.properties.Property;

/**
 * A custom Jackson serializer for handling additional properties in a map.
 * <p>
 * This serializer iterates over a map and writes each key-value pair as a
 * field to the JSON generator. It is designed to work with the
 * {@code @JsonAnyGetter} annotation.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
public class AdditionalPropertiesSerializer extends StdSerializer<Object>{
	
	/**
	 * Default constructor.
	 */
	public AdditionalPropertiesSerializer() {
		super(null, true);
	}
	
	/**
	 * Constructor that accepts a serializer to delegate to.
	 *
	 * @param stdSerializer The delegate serializer.
	 */
	public AdditionalPropertiesSerializer(StdSerializer<Object> stdSerializer) {
		super(stdSerializer);
	}

	/**
	 * Generated Serial verison UID
	 */
	private static final long serialVersionUID = -3198778268947046277L;

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void serialize(Object obj, JsonGenerator generator, SerializerProvider provider) throws IOException {
		@SuppressWarnings("unchecked")
		Map<String, Object> map = (Map<String,Object>) obj;
		for(String key : map.keySet()) {
			Object object = map.get(key);
			if(object instanceof Property) {
				generator.writeObjectField(key, (Property) object);
			}else {
				generator.writeObjectField(key, object);
			}
		}
	}
	
}
