package org.gcube.informationsystem.queries.templates.reference.properties;

import java.util.Map;

import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.informationsystem.model.reference.properties.Property;
import org.gcube.informationsystem.queries.templates.impl.properties.QueryTemplateReferenceImpl;
import org.gcube.informationsystem.queries.templates.reference.entities.QueryTemplate;
import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.informationsystem.types.reference.Change;
import org.gcube.informationsystem.types.reference.TypeMetadata;
import org.gcube.informationsystem.utils.Version;

/**
 * A property that references a {@link QueryTemplate} and provides values for
 * its variables.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonDeserialize(as=QueryTemplateReferenceImpl.class)
@TypeMetadata(
	name = QueryTemplateReference.NAME,
	description = "This property references a query template to invoke with the specified variables to provide.",
	version = Version.MINIMAL_VERSION_STRING
)
@Change(version = Version.MINIMAL_VERSION_STRING, description = Version.MINIMAL_VERSION_DESCRIPTION)
public interface QueryTemplateReference extends Property {
	
	/** The name of the QueryTemplateReference property type. */
	public static final String NAME = "QueryTemplateReference"; // QueryTemplateReference.class.getSimpleName();
	
	/** The property name for the referenced template's name. */
	public static final String NAME_PROPERTY = "name";
	/** The property name for the variable values. */
	public static final String VARIABLES_PROPERTY = "variables";

	/**
	 * Returns the name of the referenced query template.
	 *
	 * @return The template name.
	 */
	@ISProperty(name = NAME_PROPERTY, description = "The name of the query template to refer", mandatory = true, nullable = false)
	public String getName();
	
	/**
	 * Sets the name of the referenced query template.
	 *
	 * @param name The template name.
	 */
	public void setName(String name);

	/**
	 * Returns the values for the template variables.
	 *
	 * @return A map of variable names to their values.
	 */
	@ISProperty(name = VARIABLES_PROPERTY, description = "The query template variables values", mandatory = false, nullable = true)
	public Map<String,Object> getVariables();
	
	/**
	 * Sets the values for the template variables.
	 *
	 * @param variables A map of variable names to their values.
	 */
	public void setVariables(Map<String,Object> variables);

	/**
	 * Adds or updates a single variable's value.
	 *
	 * @param name  The name of the variable.
	 * @param value The value of the variable.
	 */
	public void addVariable(String name, Object value);

}
