/**
 * 
 */
package org.gcube.informationsystem.queries.templates.impl.properties;



import org.gcube.com.fasterxml.jackson.annotation.JsonIgnore;
import org.gcube.com.fasterxml.jackson.annotation.JsonSetter;
import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.base.impl.properties.PropertyElementImpl;
import org.gcube.informationsystem.queries.templates.reference.properties.TemplateVariable;
import org.gcube.informationsystem.types.PropertyTypeName;
import org.gcube.informationsystem.types.reference.properties.PropertyDefinition;
import org.gcube.informationsystem.utils.AttributeUtility;

/**
 * The default implementation of the {@link TemplateVariable} interface.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value=TemplateVariable.NAME)
public class TemplateVariableImpl extends PropertyElementImpl implements TemplateVariable {

	/**
	 * The serial version UID.
	 */
	private static final long serialVersionUID = 2628113641100130640L;
	
	/** The name of the variable. */
	protected String name;
	/** The description of the variable. */
	protected String description;
	/** The maximum value of the variable. */
	private Integer max= null;
	/** The minimum value of the variable. */
	private Integer min= null;
	/** The regular expression for the variable. */
	private String regexp= null;
	/** The type of the variable. */
	private PropertyTypeName propertyTypeName = null;
	/** The default value of the variable. */
	protected Object defaultValue;
	
	/**
	 * Default constructor.
	 */
	public TemplateVariableImpl() {
		super();
		/* TODO consider if we want to have a default type
		 * setPropertyType(PropertyTypeName.BaseType.STRING.name());
		 */
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getName() {
		return name;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getDescription() {
		return description;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setDescription(String description) {
		this.description = description;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public Integer getMax() {
		return max;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setMax(Integer max) {
		this.max = max;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public Integer getMin() {
		return min;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setMin(Integer min) {
		this.min = min;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getRegexp() {
		return regexp;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setRegexp(String regexp) {
		AttributeUtility.checkRegex(regexp, null);
		this.regexp = regexp;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getPropertyType() {
		return propertyTypeName.toString();
	}

	/**
	 * Sets the property type.
	 *
	 * @param type the type
	 */
	@JsonSetter(value = PropertyDefinition.PROPERTY_TYPE_PROPERTY)
	public void setPropertyType(String type) {
		this.propertyTypeName = new PropertyTypeName(type);
	}
	
	/**
	 * Gets the property type name.
	 *
	 * @return the property type name
	 */
	@JsonIgnore
	public PropertyTypeName getPropertyTypeName() {
		return propertyTypeName;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public Object getDefaultValue() {
		return defaultValue;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setDefaultValue(Object defaultValue) {
		this.defaultValue = defaultValue;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return "TemplateVariable ["
				+ "name=" + name
				+ ", description=" + description
				+ ", max=" + max
				+ ", min=" + min
				+ ", regexpr=" + regexp
				+ ", type=" + (propertyTypeName==null ?  "null" : propertyTypeName.toString())
				+ ", defaultValue=" + (defaultValue == null ? "null" : defaultValue.toString())
				+ "]";
	}
	
}
