package org.gcube.informationsystem.queries.templates.impl.properties;

import java.util.HashMap;
import java.util.Map;

import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.model.impl.properties.PropertyImpl;
import org.gcube.informationsystem.queries.templates.reference.properties.QueryTemplateReference;

/**
 * The default implementation of the {@link QueryTemplateReference} interface.
 *
 * @author Luca Frosini (ISTI CNR)
 */
@JsonTypeName(value=QueryTemplateReference.NAME)
public class QueryTemplateReferenceImpl extends PropertyImpl implements QueryTemplateReference {

	/**
	 * The serial version UID.
	 */
	private static final long serialVersionUID = -9079792255348990664L;

	/** The name of the query template. */
	protected String name;
	/** The variables of the query template. */
	protected Map<String, Object> variables;

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getName() {
		return name;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Map<String, Object> getVariables() {
		return variables;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setVariables(Map<String, Object> variables) {
		this.variables = variables;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void addVariable(String name, Object value) {
		if(this.variables == null) {
			this.variables = new HashMap<String, Object>();
		}
		this.variables.put(name, value);
	}

}
