/**
 * 
 */
package org.gcube.informationsystem.model.reference.relations;

import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.types.annotations.Abstract;
import org.gcube.informationsystem.types.reference.Change;
import org.gcube.informationsystem.types.reference.TypeMetadata;
import org.gcube.informationsystem.utils.Version;

/**
 * Represents an "IsRelatedTo" relationship, indicating that a {@link Resource}
 * is related to another {@link Resource}.
 * <p>
 * This is a specialized, abstract type of {@link Relation} that models
 * associations between resources. For more details, refer to the
 * <a href="https://wiki.gcube-system.org/gcube/Facet_Based_Resource_Model#IsRelatedTo">
 * gCube Facet Based Resource Model Wiki</a>.
 *
 * @param <S> The type of the source resource.
 * @param <T> The type of the target resource.
 * @author Luca Frosini (ISTI - CNR)
 * @see Relation
 * @see Resource
 */
@Abstract
// @JsonDeserialize(as=IsRelatedToImpl.class) Do not uncomment to manage subclasses
@TypeMetadata(name = IsRelatedTo.NAME, description = "This is the base type for any IsRelatedTo relation", version = Version.MINIMAL_VERSION_STRING)
@Change(version = Version.MINIMAL_VERSION_STRING, description = Version.MINIMAL_VERSION_DESCRIPTION)
public interface IsRelatedTo<S extends Resource, T extends Resource>
		extends Relation<S, T> {
	
	/** The name of the IsRelatedTo relation type. */
	public static final String NAME = "IsRelatedTo"; //IsRelatedTo.class.getSimpleName();
	
}
