/**
 * 
 */
package org.gcube.informationsystem.model.reference.properties;

import java.util.Map;

import org.gcube.com.fasterxml.jackson.annotation.JsonAnyGetter;
import org.gcube.com.fasterxml.jackson.annotation.JsonAnySetter;
import org.gcube.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.base.reference.SchemaMixedElement;
import org.gcube.informationsystem.base.reference.properties.PropertyElement;
import org.gcube.informationsystem.model.impl.properties.PropertyImpl;
import org.gcube.informationsystem.model.reference.ModelElement;
import org.gcube.informationsystem.serialization.AdditionalPropertiesSerializer;
import org.gcube.informationsystem.types.reference.Change;
import org.gcube.informationsystem.types.reference.TypeMetadata;
import org.gcube.informationsystem.utils.Version;

/**
 * The base interface for all properties in the Information System model.
 * <p>
 * This interface serves as a common root for all property types, combining the
 * functionalities of {@link PropertyElement}, {@link SchemaMixedElement}, and
 * {@link ModelElement}. It provides a foundation for extensible, model-aware
 * properties.
 *
 * @author Luca Frosini (ISTI - CNR)
 * @see PropertyElement
 * @see SchemaMixedElement
 * @see ModelElement
 */
// @JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder({ Element.TYPE_PROPERTY, ModelElement.SUPERTYPES_PROPERTY, ModelElement.EXPECTED_TYPE_PROPERTY })
@JsonDeserialize(as=PropertyImpl.class)
@TypeMetadata(name = Property.NAME, description = "This is the base type for any Property", version = Version.MINIMAL_VERSION_STRING)
@Change(version = Version.MINIMAL_VERSION_STRING, description = Version.MINIMAL_VERSION_DESCRIPTION)
public interface Property extends PropertyElement, SchemaMixedElement, ModelElement {
	
	/** The name of the property type. */
	public static final String NAME = "Property"; //Property.class.getSimpleName();
	
	/**
	 * {@inheritDoc}
	 */
	@JsonAnyGetter
	@JsonSerialize(using = AdditionalPropertiesSerializer.class)
	@Override
	public Map<String,Object> getAdditionalProperties();
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setAdditionalProperties(Map<String,Object> additionalProperties);
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public Object getAdditionalProperty(String key);
	
	/**
	 * {@inheritDoc}
	 */
	@JsonAnySetter
	@Override
	public void setAdditionalProperty(String key, Object value);
	
}
