package org.gcube.informationsystem.model.reference.entities;

import java.util.Map;

import org.gcube.com.fasterxml.jackson.annotation.JsonAnyGetter;
import org.gcube.com.fasterxml.jackson.annotation.JsonAnySetter;
import org.gcube.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.gcube.informationsystem.base.reference.SchemaMixedElement;
import org.gcube.informationsystem.serialization.AdditionalPropertiesSerializer;
import org.gcube.informationsystem.types.annotations.Abstract;
import org.gcube.informationsystem.types.reference.Change;
import org.gcube.informationsystem.types.reference.TypeMetadata;
import org.gcube.informationsystem.utils.Version;

/**
 * Represents a facet, which describes a specific aspect or dimension of a
 * {@link Resource}.
 * <p>
 * Facets are extensible entities that support additional properties not defined
 * in the formal schema, through the {@link SchemaMixedElement} interface. For
 * more details, refer to the
 * <a href="https://wiki.gcube-system.org/gcube/Facet_Based_Resource_Model#Facet">
 * gCube Facet Based Resource Model Wiki</a>.
 *
 * @author Luca Frosini (ISTI - CNR)
 * @see Entity
 * @see SchemaMixedElement
 * @see Resource
 */
@Abstract
// @JsonDeserialize(as=FacetImpl.class) Do not uncomment to manage subclasses
@TypeMetadata(name = "Facet", description = "This is the base type for any Facet", version = Version.MINIMAL_VERSION_STRING)
@Change(version = Version.MINIMAL_VERSION_STRING, description = Version.MINIMAL_VERSION_DESCRIPTION)
public interface Facet extends Entity, SchemaMixedElement {
	
	/** The name of the facet type. */
	public static final String NAME = "Facet"; //Facet.class.getSimpleName();
	
	/**
	 * {@inheritDoc}
	 * <p>
	 * This method allows retrieving all additional properties of the facet that
	 * are not part of its defined schema.
	 */
	@JsonAnyGetter
	@JsonSerialize(using = AdditionalPropertiesSerializer.class)
	@Override
	public Map<String,Object> getAdditionalProperties();
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setAdditionalProperties(Map<String,Object> additionalProperties);
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public Object getAdditionalProperty(String key);
	
	/**
	 * {@inheritDoc}
	 * <p>
	 * This method allows setting additional properties on the facet that are not
	 * part of its defined schema.
	 */
	@JsonAnySetter
	@Override
	public void setAdditionalProperty(String key, Object value);
	
}
