package org.gcube.informationsystem.model.reference;

import java.util.List;

import org.gcube.com.fasterxml.jackson.annotation.JsonGetter;
import org.gcube.com.fasterxml.jackson.annotation.JsonInclude;
import org.gcube.com.fasterxml.jackson.annotation.JsonInclude.Include;
import org.gcube.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.gcube.informationsystem.base.reference.Element;

/**
 * A base interface for elements that are part of the core Information System model.
 * <p>
 * This interface provides support for type hierarchies by including properties
 * for supertypes and the expected type during deserialization.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonPropertyOrder({ Element.TYPE_PROPERTY, ModelElement.SUPERTYPES_PROPERTY, ModelElement.EXPECTED_TYPE_PROPERTY })
public interface ModelElement extends Element {

	/**
	 * The property name for the list of supertypes of the element.
	 */
	public static final String SUPERTYPES_PROPERTY = "supertypes";
	
	/**
	 * The property name used by the deserializer to indicate the originally
	 * expected type when a more generic supertype had to be used for
	 * deserialization.
	 */
	public static final String EXPECTED_TYPE_PROPERTY = "expectedtype";
	
	/**
	 * Returns the list of supertypes for this element.
	 * <p>
	 * This list is included in JSON serialization only if it is not empty.
	 *
	 * @return A {@link List} of supertype names.
	 */
	@JsonInclude(Include.NON_EMPTY)
	@JsonGetter(value = SUPERTYPES_PROPERTY)
	public List<String> getSupertypes();
	
	/**
	 * Returns the name of the expected type.
	 * <p>
	 * This is used during deserialization to indicate the original type when a
	 * fallback to a supertype was necessary. It is included in JSON
	 * serialization only if it is not empty.
	 *
	 * @return The expected type name.
	 */
	@JsonInclude(Include.NON_EMPTY)
	@JsonGetter(value = EXPECTED_TYPE_PROPERTY)
	public String getExpectedtype();
	
}
