package org.gcube.informationsystem.model.reference;

import java.util.Map;
import java.util.UUID;

import org.gcube.com.fasterxml.jackson.annotation.JsonGetter;
import org.gcube.com.fasterxml.jackson.annotation.JsonInclude;
import org.gcube.com.fasterxml.jackson.annotation.JsonInclude.Include;
import org.gcube.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.base.reference.IdentifiableElement;

/**
 * An interface for identifiable entity-relationship (ER) elements of the model.
 * <p>
 * This serves as a common type for core model elements like {@code Resource},
 * {@code Facet}, {@code IsRelatedTo}, and {@code ConsistsOf}. It extends
 * {@link IdentifiableElement} and {@link ModelElement}, and adds a property to
 * retrieve the contexts in which the element exists.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonPropertyOrder({ Element.TYPE_PROPERTY, ModelElement.SUPERTYPES_PROPERTY, ModelElement.EXPECTED_TYPE_PROPERTY, IdentifiableElement.ID_PROPERTY, IdentifiableElement.METADATA_PROPERTY, ERElement.CONTEXTS_PROPERTY })
public interface ERElement extends IdentifiableElement, ModelElement {

	/**
	 * The property name for the map of contexts associated with the element.
	 * <p>
	 * This property is not native to the model but is generated by the server
	 * for administrative client convenience.
	 */
	public static final String CONTEXTS_PROPERTY = "contexts";
	
	/**
	 * Returns a map of contexts where this element is present.
	 * <p>
	 * The map keys are the context UUIDs, and the values are the context names.
	 * This property is included in JSON serialization only if it is not null.
	 *
	 * @return A {@link Map} of context UUIDs to context names, or {@code null}.
	 */
	@JsonInclude(Include.NON_NULL)
	@JsonGetter(value = CONTEXTS_PROPERTY)
	public Map<UUID,String> getContexts();
}
