package org.gcube.informationsystem.model.knowledge;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.gcube.informationsystem.base.reference.AccessType;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class UsageKnowledge<U> {
	
	/** The map of usages. */
	protected Map<String, List<U>> map;
	
	/**
	 * Creates a new instance.
	 *
	 * @param accessType The access type.
	 */
	public UsageKnowledge(AccessType accessType){
		this.map = new LinkedHashMap<>();
	}
	
	/**
	 * Adds a usage for a type.
	 *
	 * @param typeName The type name.
	 * @param u The usage.
	 */
	public void add(String typeName, U u) {
		List<U> list = map.get(typeName);
		if(list==null) {
			list = new ArrayList<>();
			map.put(typeName, list);
		}
		list.add(u);
	}
	
	/**
	 * Returns the usages for a type.
	 *
	 * @param typeName The type name.
	 * @return The list of usages.
	 */
	public List<U> getUsage(String typeName){
		List<U> list = map.get(typeName);
		return list;
	}
	
}
