package org.gcube.informationsystem.model.knowledge;

import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.tree.NodeInformation;

/**
 * Extends {@link NodeInformation} to provide additional type-related information.
 *
 * @param <T> The type of the element.
 * @author Luca Frosini (ISTI - CNR)
 */
public interface TypeInformation<T> extends NodeInformation<T> {
	
	/**
	 * Returns the {@link AccessType} of the given element.
	 *
	 * @param t The element.
	 * @return The access type.
	 */
	public AccessType getAccessType(T t);
	
	/**
	 * Returns the root element for a given {@link AccessType}.
	 *
	 * @param accessType The access type.
	 * @return The root element.
	 */
	public T getRoot(AccessType accessType);
	
}
