/**
 * 
 */
package org.gcube.informationsystem.model.impl.relations;



import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.model.impl.properties.PropagationConstraintImpl;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.properties.PropagationConstraint;
import org.gcube.informationsystem.model.reference.properties.PropagationConstraint.AddConstraint;
import org.gcube.informationsystem.model.reference.properties.PropagationConstraint.DeleteConstraint;
import org.gcube.informationsystem.model.reference.properties.PropagationConstraint.RemoveConstraint;
import org.gcube.informationsystem.model.reference.relations.ConsistsOf;

/**
 * The default implementation of the {@link ConsistsOf} interface.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value=ConsistsOf.NAME)
public class ConsistsOfImpl<S extends Resource, T extends Facet> extends
		RelationImpl<S, T> implements ConsistsOf<S, T> {

	/**
	 * The serial version UID.
	 */
	private static final long serialVersionUID = -4903629726765659155L;

	/**
	 * Default constructor.
	 */
	protected ConsistsOfImpl(){
		super();
	}
	
	/**
	 * Constructs a new {@code ConsistsOfImpl} with the given source and target.
	 *
	 * @param source The source resource.
	 * @param target The target facet.
	 */
	public ConsistsOfImpl(S source, T target) {
		this(source, target, null);
	}
	
	/**
	 * Constructs a new {@code ConsistsOfImpl} with the given source, target, and propagation constraint.
	 *
	 * @param source                The source resource.
	 * @param target                The target facet.
	 * @param propagationConstraint The propagation constraint.
	 */
	public ConsistsOfImpl(S source, T target,
			PropagationConstraint propagationConstraint) {
		super(source, target, propagationConstraint);
		if(this.propagationConstraint==null) {
			this.propagationConstraint = new PropagationConstraintImpl();
			this.propagationConstraint.setAddConstraint(AddConstraint.propagate);
			this.propagationConstraint.setRemoveConstraint(RemoveConstraint.cascade);
			this.propagationConstraint.setDeleteConstraint(DeleteConstraint.cascade);
		}
	}
	
}
