/**
 * 
 */
package org.gcube.informationsystem.model.impl.properties;



import org.gcube.com.fasterxml.jackson.annotation.JsonFormat;
import org.gcube.com.fasterxml.jackson.annotation.JsonProperty;
import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.model.reference.properties.PropagationConstraint;

/**
 * The default implementation of the {@link PropagationConstraint} interface.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value=PropagationConstraint.NAME)
public final class PropagationConstraintImpl extends PropertyImpl implements PropagationConstraint {

	/**
	 * The serial version UID.
	 */
	private static final long serialVersionUID = -4708881022038107688L;

	/** The add constraint. */
	@JsonFormat(shape=JsonFormat.Shape.STRING)
	@JsonProperty(value=ADD_PROPERTY)
	protected AddConstraint addConstraint;
	
	/** The delete constraint. */
	@JsonFormat(shape=JsonFormat.Shape.STRING)
	@JsonProperty(value=DELETE_PROPERTY)
	protected DeleteConstraint deleteConstraint;
	
	/** The remove constraint. */
	@JsonFormat(shape=JsonFormat.Shape.STRING)
	@JsonProperty(value=REMOVE_PROPERTY)
	protected RemoveConstraint removeConstraint;
	
	/**
	 * Default constructor.
	 */
	public PropagationConstraintImpl(){
		super();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public AddConstraint getAddConstraint() {
		return this.addConstraint;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setAddConstraint(AddConstraint addConstraint) {
		this.addConstraint = addConstraint;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public DeleteConstraint getDeleteConstraint() {
		return this.deleteConstraint;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setDeleteConstraint(DeleteConstraint deleteConstraint) {
		this.deleteConstraint = deleteConstraint;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public RemoveConstraint getRemoveConstraint() {
		return this.removeConstraint;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setRemoveConstraint(RemoveConstraint removeConstraint) {
		this.removeConstraint = removeConstraint;
	}

}
