/**
 * 
 */
package org.gcube.informationsystem.model.impl.properties;

import java.util.Date;

import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.model.reference.properties.Metadata;

/**
 * The default implementation of the {@link Metadata} interface.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value=Metadata.NAME)
public final class MetadataImpl extends PropertyImpl implements Metadata {

	/**
	 * The serial version UID.
	 */
	private static final long serialVersionUID = 5102553511155113169L;

	/** The user who created the element. */
	protected String createdBy;
	/** The time the element was created. */
	protected Date creationTime;
	/** The user who last updated the element. */
	protected String lastUpdateBy;
	/** The time the element was last updated. */
	protected Date lastUpdateTime;

	/**
	 * Default constructor.
	 */
	public MetadataImpl() {
		super();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getCreatedBy() {
		return createdBy;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Date getCreationTime() {
		return creationTime;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getLastUpdateBy() {
		return lastUpdateBy;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Date getLastUpdateTime() {
		return lastUpdateTime;
	}

}
