/**
 * 
 */
package org.gcube.informationsystem.model.impl.properties;

import java.util.Date;
import java.util.Objects;

import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.model.reference.properties.Event;

/**
 * The default implementation of the {@link Event} interface.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value=Event.NAME)
public class EventImpl extends PropertyImpl implements Event {

	/**
	 * The serial version UID.
	 */
	private static final long serialVersionUID = 5102553511155113169L;

	/** A description of what happened. */
	protected String what;
	/** When the event occurred. */
	protected Date when;
	/** Who triggered the event. */
	protected String who;
	/** Where the event occurred. */
	protected String where;
	/** The reason why the event occurred. */
	protected String why;
	/** How the event occurred. */
	protected String how;
	
	/**
	 * Default constructor.
	 */
	public EventImpl() {
		super();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getWhat() {
		return what;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setWhat(String what) {
		this.what = what;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public Date getWhen() {
		return when;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setWhen(Date when) {
		this.when = when;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getWho() {
		return who;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setWho(String who) {
		this.who = who;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getWhere() {
		return where;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setWhere(String where) {
		this.where = where;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getWhy() {
		return why;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setWhy(String why) {
		this.why = why;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getHow() {
		return how;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setHow(String how) {
		this.how = how;
	}
	
	/**
	 * Compares two strings.
	 *
	 * @param sThis  The first string.
	 * @param sOther The second string.
	 * @return 0 if the strings are equal, a negative value if the first string is
	 *         less than the second, or a positive value if the first string is
	 *         greater than the second.
	 */
	private int compareStrings(String sThis, String sOther) {
		return 0;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int compareTo(Event o) {
		if(o == null) {
            return 1;
		}
		
		int compare = 0;
		if(this.when==null) {
			if(o.getWhen()==null) {
				compare = 0;
			}else {
				compare = 1;
			}
		}else {
			if(o.getWhen()==null) {
				compare = -1;
			}else {
				compare = this.when.compareTo(o.getWhen());
			}
		}
		if(compare!=0) {
			return compare;
		}
		
		compare = compareStrings(this.what,o.getWhat());
		if(compare!=0) {
			return compare;
		}
		
		compare = compareStrings(this.who,o.getWho());
		if(compare!=0) {
			return compare;
		}
		
		compare = compareStrings(where,o.getWhere());
		if(compare!=0) {
			return compare;
		}
		
		compare = compareStrings(why,o.getWhy());
		if(compare!=0) {
			return compare;
		}
		
		compare = compareStrings(how,o.getHow());
		return compare;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public int hashCode() {
		return Objects.hash(how, what, when, where, who, why);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		EventImpl other = (EventImpl) obj;
		return Objects.equals(how, other.how) && Objects.equals(what, other.what) && Objects.equals(when, other.when)
				&& Objects.equals(where, other.where) && Objects.equals(who, other.who)
				&& Objects.equals(why, other.why);
	}
}
