/**
 * 
 */
package org.gcube.informationsystem.model.impl.properties;



import org.gcube.com.fasterxml.jackson.annotation.JsonIgnore;
import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.model.reference.properties.Encrypted;

/**
 * The default implementation of the {@link Encrypted} interface.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value = Encrypted.NAME)
public class EncryptedImpl extends PropertyImpl implements Encrypted {

	/**
	 * The serial version UID.
	 */
	private static final long serialVersionUID = 7823031209294161865L;
	
	/** The encrypted value. */
	@JsonIgnore
	protected String value;
	
	/**
	 * Default constructor.
	 */
	public EncryptedImpl() {
		super();
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getValue() {
		return value;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setValue(String value) {
		this.value = value;
	}
	
}
