/**
 * 
 */
package org.gcube.informationsystem.model.impl.entities;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.gcube.com.fasterxml.jackson.annotation.JsonIgnore;
import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.model.reference.properties.Property;
import org.gcube.informationsystem.serialization.ElementMapper;

/**
 * The default abstract implementation of the {@link Facet} interface.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value=Facet.NAME)
public abstract class FacetImpl extends EntityImpl implements Facet {

	/**
	 * The serial version UID.
	 */
	private static final long serialVersionUID = 6075565284892615813L;
	
	/** Additional properties of the facet. */
	@JsonIgnore
	protected Map<String, Object> additionalProperties;
	
	/**
	 * A set of keys that are allowed as additional properties, even if they start
	 * with '_' or '@'.
	 */
	@JsonIgnore
	protected final Set<String> allowedAdditionalKeys;
	
	/**
	 * Default constructor.
	 */
	protected FacetImpl(){
		super();
		this.additionalProperties = new HashMap<>();
		this.allowedAdditionalKeys = new HashSet<>();
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public Map<String, Object> getAdditionalProperties() {
		return additionalProperties;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setAdditionalProperties(Map<String, Object> additionalProperties) {
		this.additionalProperties = additionalProperties;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Object getAdditionalProperty(String key) {
		return additionalProperties.get(key);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setAdditionalProperty(String key, Object value) {
		if(!allowedAdditionalKeys.contains(key)){
			if(key.startsWith("_")) {
				return;
			}
			if(key.startsWith("@")) {
				return;
			}
		}
		
		/*
		Additional properties are not deserialized to the proper property type.
		The first attempt was to try to write a specific deserializer but it fails.	
		This fix the issue.
		*/
		try {
			if(value instanceof Map<?,?>) {
				@SuppressWarnings("unchecked")
				Map<String, Object> map = (Map<String,Object>) value;
				if(map.containsKey(Element.TYPE_PROPERTY)) {
					String reserialized = ElementMapper.getObjectMapper().writeValueAsString(map);
					Property property = ElementMapper.unmarshal(Property.class, reserialized);
					value = property;
				}
			}
		}catch (Throwable e) {
			e.getMessage();
			// Any type of error/exception must be catched
		}
		/* END of fix to properly deserialize Property types*/
		
		this.additionalProperties.put(key, value);
	}

	/**
	 * Adds a key to the set of allowed additional keys.
	 *
	 * @param allowedAdditionalKey The key to add.
	 */
	public void addAllowedAdditionalKey(String allowedAdditionalKey){
		this.allowedAdditionalKeys.add(allowedAdditionalKey);
	}

}
