/**
 * 
 */
package org.gcube.informationsystem.model.impl.entities;

import java.util.List;
import java.util.Map;
import java.util.UUID;

import org.gcube.com.fasterxml.jackson.annotation.JsonSetter;
import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.base.impl.entities.EntityElementImpl;
import org.gcube.informationsystem.model.reference.ERElement;
import org.gcube.informationsystem.model.reference.entities.Entity;

/**
 * The default abstract implementation of the {@link Entity} interface.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value=Entity.NAME)
public abstract class EntityImpl extends EntityElementImpl implements Entity {

	/**
	 * The serial version UID.
	 */
	private static final long serialVersionUID = -4488771434017342703L;
	
	/** The list of supertypes. */
	protected List<String> supertypes;
	/** The expected type. */
	protected String expectedtype;
	/** The contexts in which the entity exists. */
	protected Map<UUID,String> contexts;
	
	/**
	 * Default constructor.
	 */
	protected EntityImpl(){
		super();
		this.metadata = null;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public List<String> getSupertypes() {
		return this.supertypes;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getExpectedtype() {
		return this.expectedtype;
	}
	
	/**
	 * {@inheritDoc}
	 */
	public Map<UUID,String> getContexts(){
		return this.contexts;
	}
	
	/**
	 * Sets the contexts in which the entity exists.
	 *
	 * @param contexts The contexts.
	 */
	@JsonSetter(value = ERElement.CONTEXTS_PROPERTY)
	protected void setContexts(Map<UUID,String> contexts) {
		this.contexts = contexts;
	}
}
