package org.gcube.informationsystem.discovery;

import java.util.Collection;

/**
 * An interface for providers that supply package information for model registration.
 * <p>
 * Implementations of this interface are used to identify the packages that
 * contain the model's type definitions, which need to be registered with the
 * system. Any implementation must have a no-argument constructor.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
public interface RegistrationProvider {
	
	/**
	 * Returns the name of the model.
	 *
	 * @return The model name.
	 */
	public String getModelName();
	
	/**
	 * Returns a collection of packages that contain the model's type definitions.
	 *
	 * @return A collection of packages to be registered.
	 */
	public Collection<Package> getPackagesToRegister();
	
}
