package org.gcube.informationsystem.discovery;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.Element;

/**
 * A {@link RegistrationProvider} for the core Information System (IS) model.
 * <p>
 * This class identifies the packages containing the core IS model types that
 * need to be registered.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
public class ISModelRegistrationProvider implements RegistrationProvider {

	/** The name of the Information System model. */
	public static final String IS_MODEL_NAME = "Information System (IS) Model";
	
	private static Set<Package> packages;
	
	static {
		packages = new HashSet<>();
		for(AccessType accessType : AccessType.getModelTypes()) {
			Class<Element> clz = accessType.getTypeClass();
			packages.add(clz.getPackage());
		}
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public Collection<Package> getPackagesToRegister() {
		return ISModelRegistrationProvider.packages;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getModelName() {
		return IS_MODEL_NAME;
	}

}
