/**
 * 
 */
package org.gcube.informationsystem.discovery;

import org.gcube.informationsystem.base.reference.Element;

/**
 * An action to be performed on a discovered element during the discovery process.
 *
 * @param <E> The type of the element.
 * @author Luca Frosini (ISTI - CNR)
 */
public interface DiscoveredElementAction<E extends Element> {

	/**
	 * Analyzes a discovered element.
	 *
	 * @param e The class of the discovered element.
	 * @throws Exception if an error occurs during analysis.
	 */
	public void analizeElement(Class<E> e) throws Exception;
	
}
