package org.gcube.informationsystem.contexts.impl.relations;



import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.base.impl.relations.RelationElementImpl;
import org.gcube.informationsystem.contexts.reference.entities.Context;
import org.gcube.informationsystem.contexts.reference.relations.IsParentOf;

/**
 * The default implementation of the {@link IsParentOf} interface.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value = IsParentOf.NAME)
public final class IsParentOfImpl extends RelationElementImpl<Context, Context> implements IsParentOf {

	/**
	 * The generated serial version UID for serialization.
	 */
	private static final long serialVersionUID = 246200525751824393L;

	/**
	 * Default constructor.
	 */
	protected IsParentOfImpl() {
		super();
	}

	/**
	 * Constructs a new {@code IsParentOfImpl} with the given source and target.
	 *
	 * @param source The source context.
	 * @param target The target context.
	 */
	public IsParentOfImpl(Context source, Context target) {
		super(source, target);
	}

}
