package org.gcube.informationsystem.base.reference.properties;

import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.informationsystem.base.impl.properties.PropertyElementImpl;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.types.reference.Change;
import org.gcube.informationsystem.types.reference.TypeMetadata;
import org.gcube.informationsystem.utils.Version;

/**
 * The base interface for all property elements in the Information System model.
 * <p>
 * This interface serves as a common root for all types of properties, providing
 * a foundational type for management and serialization purposes.
 *
 * @author Luca Frosini (ISTI - CNR)
 * @see Element
 */
@JsonDeserialize(as=PropertyElementImpl.class)
@TypeMetadata(name = PropertyElement.NAME, description = "This is the base type for any PropertyElement", version = Version.MINIMAL_VERSION_STRING)
@Change(version = Version.MINIMAL_VERSION_STRING, description = Version.MINIMAL_VERSION_DESCRIPTION)
public interface PropertyElement extends Element {
	
	/** The name of the property element type. */
	public static final String NAME = "PropertyElement"; //PropertyElement.class.getSimpleName();
	
}
