package org.gcube.informationsystem.base.reference;

import java.util.Map;

/**
 * An element that supports "schema-mixed" mode, allowing for properties not
 * explicitly defined in the schema.
 * <p>
 * This interface provides a mechanism to handle additional, non-standard
 * properties as a key-value map. It is useful for elements that need to be
 * extensible and accommodate dynamic attributes.
 *
 * @author Luca Frosini (ISTI - CNR)
 * @see Element
 */
public interface SchemaMixedElement extends Element {
	
	/**
	 * Returns a map of all additional properties not defined in the schema.
	 *
	 * @return A {@link Map} containing the additional properties, where the key is
	 *         the property name and the value is the property value.
	 */
	public Map<String,Object> getAdditionalProperties();
	
	/**
	 * Sets the map of additional properties for the element.
	 *
	 * @param additionalProperties A {@link Map} of additional properties.
	 */
	public void setAdditionalProperties(Map<String,Object> additionalProperties);
	
	/**
	 * Retrieves a single additional property by its key.
	 *
	 * @param key The name of the additional property to retrieve.
	 * @return The value of the property, or {@code null} if the key is not found.
	 */
	public Object getAdditionalProperty(String key);
	
	/**
	 * Sets a single additional property.
	 *
	 * @param key   The name of the additional property.
	 * @param value The value of the additional property.
	 */
	public void setAdditionalProperty(String key, Object value);
	
}
