package org.gcube.informationsystem.base.reference;

import java.io.Serializable;

import org.gcube.com.fasterxml.jackson.annotation.JsonIgnore;
import org.gcube.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.gcube.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.gcube.informationsystem.types.annotations.Abstract;
import org.gcube.informationsystem.types.reference.Change;
import org.gcube.informationsystem.types.reference.TypeMetadata;
import org.gcube.informationsystem.utils.Version;

/**
 * The base interface for all elements in the Information System model.
 * <p>
 * This interface provides a common foundation for various types of elements,
 * ensuring they are serializable and can be identified by type during JSON
 * processing. It defines constants for type identification and date-time
 * formatting.
 *
 * @author Luca Frosini (ISTI - CNR)
 * @see IdentifiableElement
 * @see SchemaMixedElement
 */
@Abstract
@JsonPropertyOrder({ Element.TYPE_PROPERTY })
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = Element.TYPE_PROPERTY)
// @JsonTypeIdResolver(ElementTypeIdResolver.class)
@TypeMetadata(name = Element.NAME, description = "This is the base type for Element", version = Version.MINIMAL_VERSION_STRING)
@Change(version = Version.MINIMAL_VERSION_STRING, description = Version.MINIMAL_VERSION_DESCRIPTION)
public interface Element extends Serializable {

	/**
	 * The name of the element type.
	 */
	public static final String NAME = "Element"; //Element.class.getSimpleName();
	
	/**
	 * The name of the property used to store the type of the element during JSON serialization.
	 */
	public static final String TYPE_PROPERTY = "type";
	
	/**
	 * The standard date-time pattern used for serializing and deserializing dates across all elements.
	 * The pattern is "yyyy-MM-dd HH:mm:ss.SSS Z".
	 */
	public static final String DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS Z";
	
	/**
	 * Returns the name of the element's type. This is typically used for type
	 * identification in serialized forms.
	 *
	 * @return The type name of the element.
	 */
	@JsonIgnore
	public String getTypeName();
	
}
