package org.gcube.informationsystem.base.reference;

/**
 * Specifies the direction of a relationship or flow.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
public enum Direction {
	
	/** Indicates an inward direction. */
	IN,
	/** Indicates an outward direction. */
	OUT,
	/** Indicates a bidirectional flow. */
	BOTH;

	/**
	 * Returns the opposing direction.
	 * <p>
	 * - {@code IN} becomes {@code OUT}.
	 * <p>
	 * - {@code OUT} becomes {@code IN}.
	 * <p>
	 * - {@code BOTH} remains {@code BOTH}.
	 *
	 * @return The opposite direction.
	 */
	public Direction opposite() {
		if(this.equals(IN)) {
			return OUT;
		}else if(this.equals(OUT)) {
			return IN;
		} else {
			return BOTH;
		}
	}
	
}
