package org.gcube.informationsystem.base.reference;

/**
 * Extends the {@link Attribute} interface to include properties that define
 * its requirement constraints.
 * <p>
 * This interface adds flags to specify whether an attribute is mandatory and
 * whether its value can be null.
 *
 * @author Luca Frosini (ISTI - CNR)
 * @see Attribute
 */
public interface AttributeDefinition extends Attribute {
	
	/** The property name for the 'mandatory' flag. */
	public static final String MANDATORY_PROPERTY = "mandatory";
	/** The property name for the 'notnull' flag. */
	public static final String NOT_NULL_PROPERTY = "notnull";
	
	/**
	 * Checks if the attribute is mandatory.
	 *
	 * @return {@code true} if the attribute is mandatory, {@code false} otherwise.
	 */
	public boolean isMandatory();
	
	/**
	 * Sets whether the attribute is mandatory.
	 *
	 * @param mandatory {@code true} to make the attribute mandatory, {@code false} otherwise.
	 */
	public void setMandatory(boolean mandatory);
	
	/**
	 * Checks if the attribute's value cannot be null.
	 *
	 * @return {@code true} if the attribute value must not be null, {@code false} otherwise.
	 */
	public boolean isNotnull();
	
	/**
	 * Sets whether the attribute's value can be null.
	 *
	 * @param notnull {@code true} to enforce a non-null value, {@code false} otherwise.
	 */
	public void setNotnull(boolean notnull);
	
}
