package org.gcube.informationsystem.base.impl.relations;

import java.util.UUID;

import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.base.impl.ElementImpl;
import org.gcube.informationsystem.base.reference.entities.EntityElement;
import org.gcube.informationsystem.base.reference.relations.RelationElement;
import org.gcube.informationsystem.model.reference.properties.Metadata;

/**
 * The default implementation of the {@link RelationElement} interface.
 *
 * @param <S> The type of the source entity.
 * @param <T> The type of the target entity.
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value = RelationElement.NAME)
public abstract class RelationElementImpl<S extends EntityElement, T extends EntityElement> extends ElementImpl
		implements RelationElement<S, T> {

	/**
	 * The generated serial version UID for serialization.
	 */
	private static final long serialVersionUID = 28704968813390512L;

	/** The UUID of the relation. */
	protected UUID uuid;

	/** The metadata of the relation. */
	protected Metadata metadata;

	/** The source of the relation. */
	protected S source;
	/** The target of the relation. */
	protected T target;

	/**
	 * Default constructor.
	 */
	protected RelationElementImpl() {
		super();
	}

	/**
	 * Constructs a new relation with the specified source and target entities.
	 *
	 * @param source The source entity of the relation.
	 * @param target The target entity of the relation.
	 */
	protected RelationElementImpl(S source, T target) {
		this();
		this.source = source;
		this.target = target;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public UUID getID() {
		return uuid;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setID(UUID uuid) {
		this.uuid = uuid;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Metadata getMetadata() {
		return metadata;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setMetadata(Metadata metadata) {
		this.metadata = metadata;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public S getSource() {
		return source;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setSource(S source) {
		this.source = source;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public T getTarget() {
		return target;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setTarget(T target) {
		this.target = target;
	}

}