package org.gcube.informationsystem.base.impl.entities;

import java.util.UUID;

import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.base.impl.ElementImpl;
import org.gcube.informationsystem.base.reference.entities.EntityElement;
import org.gcube.informationsystem.model.reference.properties.Metadata;

/**
 * The default implementation of the {@link EntityElement} interface.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value = EntityElement.NAME)
public abstract class EntityElementImpl extends ElementImpl implements EntityElement {

	/**
	 * The generated serial version UID for serialization.
	 */
	private static final long serialVersionUID = -4488771434017342703L;

	/** The unique identifier of the entity. */
	protected UUID uuid;
	/** The metadata of the entity. */
	protected Metadata metadata;

	/**
	 * Default constructor.
	 */
	protected EntityElementImpl() {
		super();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public UUID getID() {
		return uuid;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setID(UUID uuid) {
		this.uuid = uuid;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Metadata getMetadata() {
		return metadata;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setMetadata(Metadata metadata) {
		this.metadata = metadata;
	}

}
