package org.gcube.informationsystem.model.reference;

import java.util.Map;
import java.util.UUID;

import org.gcube.com.fasterxml.jackson.annotation.JsonGetter;
import org.gcube.com.fasterxml.jackson.annotation.JsonInclude;
import org.gcube.com.fasterxml.jackson.annotation.JsonInclude.Include;
import org.gcube.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.base.reference.IdentifiableElement;

/**
 * This interfaces is an helper to identify elements of the model
 * i.e. Resource, Facet, IsRelatedTo, ConsistsOf
 * 
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonPropertyOrder({ Element.TYPE_PROPERTY, ModelElement.SUPERTYPES_PROPERTY, ModelElement.EXPECTED_TYPE_PROPERTY, IdentifiableElement.ID_PROPERTY, IdentifiableElement.METADATA_PROPERTY, ERElement.CONTEXTS_PROPERTY })
public interface ERElement extends IdentifiableElement, ModelElement {

	/**
	 * Used when requested to include contexts in metadata.
	 * This is not a native property (it is just generated by server for administration clients convenience)
	 */
	public static final String CONTEXTS_PROPERTY = "contexts";
	
	@JsonInclude(Include.NON_NULL)
	@JsonGetter(value = CONTEXTS_PROPERTY)
	public Map<UUID,String> getContexts();
}
