package org.gcube.informationsystem.tree;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class Tree<T> {

	private boolean allowMultipleInheritance;
	
	private Node<T> root;
	private NodeInformation<T> ni;
	private Map<String, Node<T>> locate;
	
	public Tree(T t, NodeInformation<T> ni) throws Exception {
		this.allowMultipleInheritance = true;
		this.ni = ni;
		this.locate = new HashMap<>();
		this.root = new Node<>(t);
		this.root.setTree(this);
		String identifier = ni.getIdentifier(t);
		this.locate.put(identifier, root);
	}
	
	public void setAllowMultipleInheritance(boolean allowMultipleInheritance) {
		this.allowMultipleInheritance = allowMultipleInheritance;
	}
	
	public NodeInformation<T> getNodeInformation() {
		return ni;
	}
	
	public Node<T> addNode(T t) {
		String identifier = ni.getIdentifier(t);
		if(locate.containsKey(identifier)) {
			// has been already added
			return locate.get(identifier);
		}
		
		Node<T> node = new Node<>(t);
		node.setTree(this);
		
		Set<String> parentIdentifiers = ni.getParentIdentifiers(root.getNodeElement(), t);
		for(String parentIdentifier : parentIdentifiers) {
			Node<T> parentNode = locate.get(parentIdentifier);
			if(parentNode==null) {
				throw new RuntimeException("I can find parent for " + identifier + ". Missing parent is " + parentIdentifier);
			}
			
			parentNode.addChild(node);
			
			if(!allowMultipleInheritance) {
				break;
			}
		}
		
		this.locate.put(identifier, node);
		
		return node;
	}

	public Node<T> getRoot() {
		return root;
	}

	@Override
	public String toString() {
		return root.toString();
	}

	public void elaborate(NodeElaborator<T> nodeElaborator) throws Exception {
		root.elaborate(nodeElaborator);
	}
}