package org.gcube.informationsystem.tree;

import java.util.Set;
import java.util.TreeSet;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class Node<T> implements Comparable<Node<T>> {

	public static String INDENTATION = "\t";
	
	private T t;
	private Tree<T> tree;
	
	private Node<T> parent;
	private Set<Node<T>> children;
	
	public Node(T  t) {
		this.t = t;
		this.children = new TreeSet<>();
	}
	
	public Tree<T> getTree() {
		return tree;
	}

	void setTree(Tree<T> tree) {
		this.tree = tree;
	}
	
	public T getNodeElement() {
		return t;
	}
	
	public Node<T> getParent() {
		return parent;
	}
	
	public Node<T> setParent(Node<T> parent) {
		this.parent = parent;
		return this;
	}

	public Node<T> addChild(Node<T> child) {
		children.add(child);
		child.setParent(this);
		child.setTree(tree);
		return this;
	}

	public Set<Node<T>> getChildrenNodes() {
		return children;
	}
	
	public Set<T> getChildrenElement() {
		Set<T> children = new TreeSet<>();
		for (Node<T> child : this.children) {
			children.add(child.t);
		}
		return children;
	}

	@Override
	public String toString() {
		return printTree(0).toString();
	}

	private StringBuffer printTree(int level) {
		
		StringBuffer stringBuffer = new StringBuffer();
		
		NodeElaborator<T> nodeElaborator = new NodeElaborator<T>() {

			@Override
			public void elaborate(Node<T> node, int level) throws Exception {
				for (int i = 0; i < level; ++i) {
					stringBuffer.append(Node.INDENTATION);
				}
				stringBuffer.append(tree.getNodeInformation().getIdentifier(node.getNodeElement()));
				stringBuffer.append("\n");
			}
						
		};
		
		try {
			elaborate(nodeElaborator, level);
		}catch (Exception e) {
			throw new RuntimeException(e);
		}
		
		return stringBuffer;
	}

	@Override
	public int compareTo(Node<T> other) {
		if (this == other) {
			return 0;
		}
		if (other == null) {
			return -1;
		}
		if (getClass() != other.getClass()) {
			return -1;
		}
		
		NodeInformation<T> ni = tree.getNodeInformation();
		
		return ni.getIdentifier(t).compareTo(ni.getIdentifier(other.t));
	}
	
	
	public void elaborate(NodeElaborator<T> nodeElaborator) throws Exception {
		elaborate(nodeElaborator, 0);
	}
	
	protected void elaborate(NodeElaborator<T> nodeElaborator, int level) throws Exception {
		nodeElaborator.elaborate(this, level);
		for (Node<T> child : children) {
			child.elaborate(nodeElaborator, level+1);
		}
	}
}
