/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.utils.knowledge;

import java.util.HashMap;
import java.util.Set;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.types.reference.Type;
import org.gcube.informationsystem.types.reference.entities.ResourceType;
import org.gcube.informationsystem.utils.knowledge.Node;
import org.gcube.informationsystem.utils.knowledge.NodeElaborator;
import org.gcube.informationsystem.utils.knowledge.UsageKnowledge;

public class Tree {
    private Node root;
    private boolean allowMultipleInheritance;
    private HashMap<String, Node> locate = new HashMap();

    public Tree(Type head) {
        this.root = new Node(head);
        this.locate.put(head.getName(), this.root);
        this.allowMultipleInheritance = false;
    }

    public void setAllowMultipleInheritance(boolean allowMultipleInheritance) {
        this.allowMultipleInheritance = allowMultipleInheritance;
    }

    protected void createUsageKnowledge(Type type) {
        if (type.getAccessType() != AccessType.RESOURCE) {
            return;
        }
        ResourceType rt = (ResourceType)type;
        UsageKnowledge fk = UsageKnowledge.getFacetKnowledge();
        fk.addAll(rt.getFacets());
        UsageKnowledge rk = UsageKnowledge.getResourceKnowledge();
        rk.addAll(rt.getResources());
    }

    public void addNode(Type type) {
        this.createUsageKnowledge(type);
        if (this.root.getType().getName().compareTo(type.getName()) == 0) {
            return;
        }
        Set<String> superClasses = type.getSuperClasses();
        String name = type.getName();
        for (String superClass : superClasses) {
            Node parent = this.locate.get(superClass);
            if (parent == null) {
                throw new RuntimeException("I can find parent Node for " + name + ". Missing parent is " + superClass);
            }
            Node node = new Node(type);
            parent.addChild(node);
            this.locate.put(name, node);
            if (this.allowMultipleInheritance) continue;
            return;
        }
    }

    public Node getRoot() {
        return this.root;
    }

    public String toString() {
        return this.root.toString();
    }

    public void elaborate(NodeElaborator nodeElaborator) throws Exception {
        this.root.elaborate(nodeElaborator);
    }
}

