/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.utils.knowledge;

import java.util.Set;
import java.util.TreeSet;
import org.gcube.informationsystem.types.reference.Type;
import org.gcube.informationsystem.utils.knowledge.NodeElaborator;
import org.gcube.informationsystem.utils.knowledge.Tree;

public class Node
implements Comparable<Node> {
    public static String INDENTATION = "\t";
    private Type type;
    private Tree tree;
    private Node parent;
    private Set<Node> children;

    public Node(Type type) {
        this.type = type;
        this.children = new TreeSet<Node>();
    }

    public Tree getTree() {
        return this.tree;
    }

    private void setTree(Tree tree) {
        this.tree = tree;
    }

    public Type getType() {
        return this.type;
    }

    public Node getParent() {
        return this.parent;
    }

    public Node setParent(Node parent) {
        this.parent = parent;
        return this;
    }

    public Node addChild(Node child) {
        this.children.add(child);
        child.setParent(this);
        child.setTree(this.tree);
        return this;
    }

    public Set<Node> getChildrenNodes() {
        return this.children;
    }

    public Set<Type> getChildren() {
        TreeSet<Type> sortedChildren = new TreeSet<Type>();
        for (Node treeNode : this.children) {
            sortedChildren.add(treeNode.type);
        }
        return sortedChildren;
    }

    public String toString() {
        return this.createTree(0).toString();
    }

    private StringBuffer createTree(int level) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            stringBuffer.append(INDENTATION);
        }
        stringBuffer.append(this.type.getName());
        for (Node child : this.children) {
            stringBuffer.append("\n");
            stringBuffer.append(child.createTree(level + 1));
        }
        return stringBuffer;
    }

    @Override
    public int compareTo(Node other) {
        if (this == other) {
            return 0;
        }
        if (other == null) {
            return -1;
        }
        if (this.getClass() != other.getClass()) {
            return -1;
        }
        return this.type.getName().compareTo(other.type.getName());
    }

    public void elaborate(NodeElaborator nodeElaborator) throws Exception {
        this.elaborate(nodeElaborator, 0);
    }

    protected void elaborate(NodeElaborator nodeElaborator, int level) throws Exception {
        nodeElaborator.elaborate(this, level);
        for (Node child : this.children) {
            child.elaborate(nodeElaborator, level + 1);
        }
    }
}

