package org.gcube.informationsystem.utils.knowledge;

import java.util.Set;
import java.util.TreeSet;

import org.gcube.informationsystem.types.reference.Type;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class Node implements Comparable<Node> {

	public static String INDENTATION = "\t";
	
	private Type type;
	
	private Tree tree;
	
	private Node parent;
	private Set<Node> children;
	
	public Node(Type type) {
		this.type = type;
		this.children = new TreeSet<Node>();
	}
	
	public Tree getTree() {
		return tree;
	}

	private void setTree(Tree tree) {
		this.tree = tree;
	}
	
	public Type getType() {
		return type;
	}
	
	public Node getParent() {
		return parent;
	}
	
	public Node setParent(Node parent) {
		this.parent = parent;
		return this;
	}

	public Node addChild(Node child) {
		children.add(child);
		child.setParent(this);
		child.setTree(tree);
		return this;
	}

	public Set<Node> getChildrenNodes() {
		return children;
	}
	
	public Set<Type> getChildren() {
		Set<Type> sortedChildren = new TreeSet<>();
		for (Node treeNode : children) {
			sortedChildren.add(treeNode.type);
		}
		return sortedChildren;
	}

	@Override
	public String toString() {
		return createTree(0).toString();
	}

	private StringBuffer createTree(int level) {
		StringBuffer stringBuffer = new StringBuffer();
		for (int i = 0; i < level; ++i) {
			stringBuffer.append(Node.INDENTATION);
		}
		stringBuffer.append(type.getName());
		for (Node child : children) {
			stringBuffer.append("\n");
			stringBuffer.append(child.createTree(level+1));
		}
		return stringBuffer;
	}

	@Override
	public int compareTo(Node other) {
		if (this == other) {
			return 0;
		}
		if (other == null) {
			return -1;
		}
		if (getClass() != other.getClass()) {
			return -1;
		}
		
		return type.getName().compareTo(other.type.getName());
	}
	
	
	public void elaborate(NodeElaborator nodeElaborator) throws Exception {
		elaborate(nodeElaborator, 0);
	}
	
	protected void elaborate(NodeElaborator nodeElaborator, int level) throws Exception {
		nodeElaborator.elaborate(this, level);
		for (Node child : children) {
			child.elaborate(nodeElaborator, level+1);
		}
	}
}
