/**
 * 
 */
package org.gcube.informationsystem.contexts.reference.entities;

import java.util.List;
import java.util.UUID;

import org.gcube.com.fasterxml.jackson.annotation.JsonGetter;
import org.gcube.com.fasterxml.jackson.annotation.JsonIgnore;
import org.gcube.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.informationsystem.base.reference.entities.EntityElement;
import org.gcube.informationsystem.contexts.impl.entities.ContextImpl;
import org.gcube.informationsystem.contexts.reference.relations.IsParentOf;
import org.gcube.informationsystem.model.reference.relations.Relation;
import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.informationsystem.types.reference.Change;
import org.gcube.informationsystem.types.reference.TypeMetadata;
import org.gcube.informationsystem.utils.Version;

/**
 * https://wiki.gcube-system.org/gcube/Facet_Based_Resource_Model#Context
 * 
 * @author Luca Frosini (ISTI - CNR) 
 */
@JsonDeserialize(as = ContextImpl.class)
@TypeMetadata(name = Context.NAME, description = "This class is the used to define a Context", version = Version.MINIMAL_VERSION_STRING)
@Change(version = Version.MINIMAL_VERSION_STRING, description = Version.MINIMAL_VERSION_DESCRIPTION)
public interface Context extends EntityElement {

	public static final String NAME = "Context"; // Context.class.getSimpleName();

	public static final String NAME_PROPERTY = "name";
	public static final String PARENT_PROPERTY = "parent";
	public static final String CHILDREN_PROPERTY = "children";

	@ISProperty(name = NAME_PROPERTY, mandatory = true, nullable = false)
	public String getName();

	public void setName(String name);

	@JsonGetter
	@JsonIgnoreProperties({ Relation.TARGET_PROPERTY })
	public IsParentOf getParent();

	@JsonIgnore
	public void setParent(UUID uuid);

	@JsonIgnore
	public void setParent(Context context);

	@JsonIgnore
	public void setParent(IsParentOf isParentOf);

	@JsonGetter
	@JsonIgnoreProperties({ Relation.SOURCE_PROPERTY })
	public List<IsParentOf> getChildren();

	public void addChild(UUID uuid);

	public void addChild(Context child);

	public void addChild(IsParentOf isParentOf);

}
