package org.gcube.informationsystem.base.reference.entities;

import org.gcube.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.base.reference.IdentifiableElement;
import org.gcube.informationsystem.model.reference.properties.Header;
import org.gcube.informationsystem.types.annotations.Abstract;
import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.informationsystem.types.reference.Change;
import org.gcube.informationsystem.types.reference.TypeMetadata;
import org.gcube.informationsystem.utils.Version;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@Abstract
@JsonIgnoreProperties(ignoreUnknown=true)
//@JsonDeserialize(as=EntityElementImpl.class) Do not uncomment to manage subclasses
@TypeMetadata(name = EntityElement.NAME, description = "This is the base class for any EntityElement", version = Version.MINIMAL_VERSION_STRING)
@Change(version = Version.MINIMAL_VERSION_STRING, description = Version.MINIMAL_VERSION_DESCRIPTION)
public interface EntityElement extends Element, IdentifiableElement {
	
	public static final String NAME = "EntityElement"; //Entity.class.getSimpleName();

	/* Overriding getHeader method to create Header property in type */
	@ISProperty(name=HEADER_PROPERTY, mandatory=true, nullable=false, description="Metadata associated with the instance that is automatically created/updated by the system.")
	@Override
	public Header getHeader();
	
}