package org.gcube.informationsystem.utils.discovery;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;

import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.types.reference.Type;

public class Discovery {

	public static List<Package> discoverPackages(){
		List<Package> packages = new ArrayList<Package>();
		
		Class<Type> tdClz = Type.class;
		packages.add(tdClz.getPackage());
		
		AccessType[] accessTypes = AccessType.values();
		for(AccessType accessType : accessTypes) {
			Class<Element> clz = accessType.getTypeClass();
			packages.add(clz.getPackage());
		}
		
		ServiceLoader<? extends RegistrationProvider> regsitrationProviders = ServiceLoader
				.load(RegistrationProvider.class);
		for(RegistrationProvider registrationProvider : regsitrationProviders) {
			packages.addAll(registrationProvider.getPackagesToRegister());
		}
		
		return packages;
	}
	
	public static void discover(SchemaAction schemaAction) throws Exception {
		List<Package> packages = Discovery.discoverPackages();
		ElementSpecilizationDiscovery.manageISM(schemaAction , packages);
	}
	
}
