package org.gcube.informationsystem.queries.templates.reference.properties;

import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.informationsystem.base.reference.properties.PropertyElement;
import org.gcube.informationsystem.queries.templates.impl.properties.TemplateVariableImpl;
import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.informationsystem.types.reference.Change;
import org.gcube.informationsystem.types.reference.TypeMetadata;
import org.gcube.informationsystem.utils.Version;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonDeserialize(as=TemplateVariableImpl.class)
@TypeMetadata(name = TemplateVariable.NAME, description = "This is the class used to define the a TemplateVariable", version = Version.MINIMAL_VERSION_STRING)
@Change(version = Version.MINIMAL_VERSION_STRING, description = Version.MINIMAL_VERSION_DESCRIPTION)
public interface TemplateVariable extends PropertyElement {

	public static final String NAME = "TemplateVariable"; // TemplateVariable.class.getSimpleName();
	
	public static final String VARIABLE_NAME_PROPERTY = "name";
	public static final String VARIABLE_DESCRIPTION_PROPERTY = "description";
	public static final String VARIABLE_DEFAULT_VALUE_PROPERTY = "defaultValue";
	
	@ISProperty(name = VARIABLE_NAME_PROPERTY, description = "The name of the Query Template Variable.", readonly = true, mandatory = true, nullable = false)
	public String getName();
	
	public void setName(String name);
	
	@ISProperty(name = VARIABLE_DESCRIPTION_PROPERTY, description = "The description of the Query Template Variable.", readonly = false, mandatory = true, nullable = false)
	public String getDescription();
	
	public void setDescription(String description);
	
	@ISProperty(name = VARIABLE_DEFAULT_VALUE_PROPERTY, description = "The default value of the Query Template Variable. The default value is used as is to the query. If the value needs quotation or escaping please include them to the default value", readonly = false, mandatory = true, nullable = false)
	public String getDefaultValue();
	
	public void setDefaultValue(String defaultValue);
	
}
