package org.gcube.informationsystem.utils;

import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public final class UUIDManager {

	public static final Set<String> RESERVED_UUID_STRING;
	public static final Set<UUID> RESERVED_UUID;
	
	private UUIDManager() {
		
	}
	
	static {
		RESERVED_UUID_STRING = new HashSet<>();
		RESERVED_UUID = new HashSet<>();
		
		String[] uuidValidCharacters = {"0","1","2","3","4","5","6","7","8","9","a","b","c","d","e","f"};
		
		for(String string : uuidValidCharacters) {
			String uuidString = "XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX";
			uuidString = uuidString.replaceAll("X", string);
			RESERVED_UUID_STRING.add(uuidString);
			RESERVED_UUID.add(UUID.fromString(uuidString));
		}
	}
	
	public static boolean isReservedUUID(UUID uuid) {
		return RESERVED_UUID.contains(uuid);
	}
	
	public static boolean isReservedUUID(String uuid) {
		return RESERVED_UUID_STRING.contains(uuid);
	}
	
	public static Set<String> getAllReservedUUIDAsStrings(){
		return new TreeSet<>(RESERVED_UUID_STRING);
	}
	
	public static Set<UUID> getAllReservedUUID(){
		return new TreeSet<>(RESERVED_UUID);
	}
	
	public static UUID generateValidRandomUUID() {
		UUID generated = UUID.randomUUID();
		while(RESERVED_UUID.contains(generated)) {
			generated = UUID.randomUUID();
		}
		return generated;
	}
}
