package org.gcube.informationsystem.types.reference.properties;

import org.gcube.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.informationsystem.base.reference.properties.PropertyElement;
import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.informationsystem.types.impl.properties.PropertyDefinitionImpl;
import org.gcube.informationsystem.types.reference.Change;
import org.gcube.informationsystem.types.reference.TypeMetadata;
import org.gcube.informationsystem.utils.Version;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonDeserialize(as = PropertyDefinitionImpl.class)
@TypeMetadata(name = PropertyDefinition.NAME, description = "This class provides information for the definition of any properties", version = Version.MINIMAL_VERSION_STRING)
@Change(version = Version.MINIMAL_VERSION_STRING, description = Version.MINIMAL_VERSION_DESCRIPTION)
public interface PropertyDefinition extends PropertyElement {
	
	public static final String NAME = "PropertyDefinition"; // PropertyDefinition.class.getSimpleName();
	
	public static final String NAME_PROPERTY = "name";
	public static final String DESCRIPTION_PROPERTY = "description";
	public static final String MANDATORY_PROPERTY = "mandatory";
	public static final String READ_ONLY_PROPERTY = "readonly";
	public static final String NOT_NULL_PROPERTY = "notnull";
	public static final String MAX_PROPERTY = "max";
	public static final String MIN_PROPERTY = "min";
	public static final String REGEX_PROPERTY = "regexp";
	public static final String TYPE_PROPERTY = "type";
	
	@ISProperty(name = NAME_PROPERTY, readonly = true, mandatory = true, nullable = false)
	public String getName();
	
	@ISProperty(name = DESCRIPTION_PROPERTY, readonly = false, mandatory = true, nullable = false)
	public String getDescription();
	
	@ISProperty(name = MANDATORY_PROPERTY, readonly = false, mandatory = true, nullable = false)
	public boolean isMandatory();
	
	@ISProperty(name = READ_ONLY_PROPERTY, readonly = false, mandatory = true, nullable = false)
	public boolean isReadonly();
	
	@ISProperty(name = NOT_NULL_PROPERTY, readonly = false, mandatory = true, nullable = false)
	public boolean isNotnull();
	
	@ISProperty(name = MAX_PROPERTY, readonly = false, mandatory = true, nullable = false)
	public Integer getMax();
	
	@ISProperty(name = MIN_PROPERTY, readonly = false, mandatory = true, nullable = false)
	public Integer getMin();
	
	@ISProperty(name = REGEX_PROPERTY, readonly = false, mandatory = true, nullable = false)
	public String getRegexp();
	
	@ISProperty(name = TYPE_PROPERTY, readonly = false, mandatory = true, nullable = false)
	public String getType();
	
}
